﻿// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See LICENSE in the project root for license information.

using UnityEngine;
using UnityEngine.EventSystems;

namespace HoloToolkit.Unity.InputModule
{
    /// <summary>
    /// Describes a Unity pointer event that was generated by a specific input source and ID.
    /// </summary>
    public class PointerInputEventData : PointerEventData, IInputSourceInfoProvider
    {
        public IInputSource InputSource { get; set; }

        public uint SourceId { get; set; }

        public PointerInputEventData(EventSystem eventSystem) : base(eventSystem)
        {
        }

        public void Clear()
        {
            Reset();
            button = InputButton.Left;
            clickCount = 0;
            clickTime = 0;
            delta = Vector2.zero;
            dragging = false;
            eligibleForClick = false;
            pointerCurrentRaycast = default(RaycastResult);
            pointerDrag = null;
            pointerEnter = null;
            pointerId = 0;
            pointerPress = null;
            pointerPressRaycast = default(RaycastResult);
            position = Vector2.zero;
            pressPosition = Vector2.zero;
            rawPointerPress = null;
            scrollDelta = Vector2.zero;
            selectedObject = null;
            useDragThreshold = false;
            InputSource = null;
            SourceId = 0;
        }
    }
}